
#ifdef TEST
#include <stdio.h>
#endif
#include "EmuApple.h"
#include "AppleDiskII.h"


const byte PROM[256] = {
0xA2,0x20,0xA0,0x00,0xA2,0x03,0x86,0x3C,0x8A,0x0A,0x24,0x3C,0xF0,0x10,0x05,0x3C
,0x49,0xFF,0x29,0x7E,0xB0,0x08,0x4A,0xD0,0xFB,0x98,0x9D,0x56,0x03,0xC8,0xE8,0x10
,0xE5,0x20,0x58,0xFF,0xBA,0xBD,0x00,0x01,0x0A,0x0A,0x0A,0x0A,0x85,0x2B,0xAA,0xBD
,0x8E,0xC0,0xBD,0x8C,0xC0,0xBD,0x8A,0xC0,0xBD,0x89,0xC0,0xA0,0x50,0xBD,0x80,0xC0
,0x98,0x29,0x03,0x0A,0x05,0x2B,0xAA,0xBD,0x81,0xC0,0xA9,0x56,
	//0x20,0xA8,0xFC,
	0xa9,0x00,0xea,
0x88
,0x10,0xEB,0x85,0x26,0x85,0x3D,0x85,0x41,0xA9,0x08,0x85,0x27,0x18,0x08,0xBD,0x8C
,0xC0,0x10,0xFB,0x49,0xD5,0xD0,0xF7,0xBD,0x8C,0xC0,0x10,0xFB,0xC9,0xAA,0xD0,0xF3
,0xEA,0xBD,0x8C,0xC0,0x10,0xFB,0xC9,0x96,0xF0,0x09,0x28,0x90,0xDF,0x49,0xAD,0xF0
,0x25,0xD0,0xD9,0xA0,0x03,0x85,0x40,0xBD,0x8C,0xC0,0x10,0xFB,0x2A,0x85,0x3C,0xBD
,0x8C,0xC0,0x10,0xFB,0x25,0x3C,0x88,0xD0,0xEC,0x28,0xC5,0x3D,0xD0,0xBE,0xA5,0x40
,0xC5,0x41,0xD0,0xB8,0xB0,0xB7,0xA0,0x56,0x84,0x3C,0xBC,0x8C,0xC0,0x10,0xFB,0x59
,0xD6,0x02,0xA4,0x3C,0x88,0x99,0x00,0x03,0xD0,0xEE,0x84,0x3C,0xBC,0x8C,0xC0,0x10
,0xFB,0x59,0xD6,0x02,0xA4,0x3C,0x91,0x26,0xC8,0xD0,0xEF,0xBC,0x8C,0xC0,0x10,0xFB
,0x59,0xD6,0x02,0xD0,0x87,0xA0,0x00,0xA2,0x56,0xCA,0x30,0xFB,0xB1,0x26,0x5E,0x00
,0x03,0x2A,0x5E,0x00,0x03,0x2A,0x91,0x26,0xC8,0xD0,0xEE,0xE6,0x27,0xE6,0x3D,0xA5
,0x3D,0xCD,0x00,0x08,0xA6,0x2B,0x90,0xDB,0x4C,0x01,0x08,0x00,0x00,0x00,0x00,0x00
	};



TAppleDiskII::TAppleDiskII(TAppleII *apple) : 
TApplePeripheral(apple) 
{ 
	curdrive = 0;
	d = &drive[0];
	flag = motor = false;
	data_latch = address_latch = 0;
};

int TAppleDiskII::read_nibble()
{
	flag = !flag;
	if (flag) 
		return 0;
	d->ensureValidData();
	d->track_index = (d->track_index + 1) % TRACK_SIZE;
	return (d->track_data[d->track_index]);
}
	
void TAppleDiskII::write_nibble(int value)
{
	if (!d->write_protect)
	{
		d->ensureValidData();
		d->track_index = (d->track_index + 1) % TRACK_SIZE;
		d->track_data[d->track_index] = (byte)value;
		d->track_is_dirty = true;
	}
}
	
/*
 * Implement the Disk II softswitches that perform the same function whether
 * they are read or written to.
 */
//const byte phaseup[] = { 3, 5, 7, 1 };
//const byte phasedn[] = { 7, 1, 3, 5 };

int TAppleDiskII::doIO(int address, int value)
{
	switch(address & 0x0f) {
	/*
	 * Turn motor phases 0 to 3 on.  Turning on the previous phase + 1
	 * increments the track position, turning on the previous phase - 1
	 * decrements the track position.  In this scheme phase 0 and 3 are
	 * considered to be adjacent.  The previous phase number can be
	 * computed as the track number % 4.
	 */
	case 0x1:
	case 0x3:
	case 0x5:
	case 0x7:
//                printf("Track I/O: %x = %x\n", address, value);
		int phase, new_track;
		new_track = d->track;
		phase = (address >> 1) & 3;

		// if new phase is even and current phase is odd
			if (phase == ((new_track - 1) & 3)) {
				if (new_track > 0)
					new_track--;
			} else
			if (phase == ((new_track + 1) & 3)) {
				if (new_track < NUM_TRACKS*2-1)
					new_track++;
			}
			d->setTrack(new_track);
//                        printf("Track %d\n", new_track);
		break;
	/*
	 * Turn drive motor off.
	 */
	case 0x8:
		if (motor) {
			motor = false;
//                        printf("Motor off");
		}
		break;
	/*
	 * Turn drive motor on.
	 */
	case 0x9:
		if (!motor) {
			motor = true;
//                        printf("Motor on");
		}
		break;
	/*
	 * Select drive 1.
	 */	
	case 0xa:
		if (curdrive != 0) {
			curdrive = 0;
			d = &drive[curdrive];
//                        printf("Select drive 0");
		}
		break;
	/*
	 * Select drive 2.
	 */
	case 0xb:
		if (curdrive != 1) {
			curdrive = 1;
			d = &drive[curdrive];
//                        printf("Select drive 1");
		}
		break;
	/*
	 * Read a disk byte if read mode is active.
	 */
	case 0xC:
		if ( address_latch == 0x0E )
			d->write_mode = false;
		else if ( address_latch == 0x0F )
			d->write_mode = true;
		if ( d->write_mode )
			write_nibble( data_latch );
		else {
			if (value < 0)
				data_latch = read_nibble();
		}
	    address_latch = 0x0C;
		if (value < 0)
			return data_latch;
		break;
	case 0xD:
		if (value >= 0)
			data_latch = value;
		address_latch = 0xD;
		break;
	case 0xE:
		if ( value < 0 && address_latch == 0x0D ) {    /* check write protect */
			address_latch = 0x0E;
			return d->write_protect? 0xFF : 0x00;
		}
		address_latch = 0x0E;
		break;
	case 0xF:
		if (value >= 0)
			data_latch = value;
		address_latch = 0xF;
		break;
	}
	return /*apple->noise()*/0;
}

int TAppleDiskII::doHighIO(int address, int value)
{
	return PROM[address & 0xff];
}

//
// TAppleDrive
//

TAppleDrive::TAppleDrive()
{
	track = 0; track_index = 0; track_read = -1;
	write_mode = false; write_protect = false;
	track_is_dirty = 0;
}

void TAppleDrive::setNewDisk()
{
	track_read = -1;
	if (diskprovider)
		write_protect = diskprovider->getIsWriteProtected();
}

void TAppleDrive::setTrack(int newtrack)
{
	track = newtrack;
}

void TAppleDrive::ensureValidData()
{
	if (track_read != track && diskprovider)
	{
		if (track_is_dirty)
		{
			diskprovider->setTrackData(track_read, track_data);
			track_is_dirty = false;
		}
		track_read = track;
		diskprovider->getTrackData(track_read, track_data);
	}
}

